# Wario Land 4

## Where is the options page?

The [player options page for this game](../player-options) contains all the
options you need to configure and export a config file.

## What does randomization do to this game?

By default, the 72 jewel pieces, 16 CDs, one full health item, and eight of Wario's moves can be
shuffled into the item pool where any player can find them. Optionally, up to 109 free-floating
diamonds may also be shuffled into the item pool. You may reduce the number of jewel pieces
available, in which case additional full health items, traps, and other in-level pickups can
be found.

As in the vanilla game, you must find your items in the levels and then escape the level through the
entry portal in order to keep them—if you die or give up from the pause menu, the item will be lost
and you will need to pick it up again, but the client will create a hint for it. Other players'
items have the same behavior by default, but you can make other players receive their items sooner
by setting your "Send Locations to Server" option to "Immediately." Note however that the randomizer
always expects you to be able to escape the level through the portal before you collect any items.

The main passages are now open from the start and don't require defeating the first boss, Spoiled
Rotten. By default, you can access the levels each passage without needing to find Keyzer in the
level before, but you can restore the vanilla behavior by setting your "Open Doors" option to
false. With another option, you can make the portals at the beginning of the level stay open so
that you don't need to press the frog switch.

In Golden Treasure Hunt and Golden Diva Treasure Hunt, the treasure chests in the boss rooms
additionally contain shuffled items, and the golden treasures they originally contained are
somewhere else in the multiworld. In the former, the Golden Diva's chamber is locked, and you
instead escape with the treasure by entering the Sound Room on the north side of the pyramid. The
number of treasures you have and what you need is displayed in the top center of the screen.

## What is the goal of Wario Land 4 when randomized?

Defeat the Golden Diva and steal the Golden Pyramid's treasure!

In Golden Treasure Hunt, find a certain number of golden treasures and escape the pyramid through
the emergency exit in the Sound Room.

In Golden Diva Treasure Hunt, find the treasures scattered in the multiworld and then defeat the
Golden Diva. Don't take too long, or else it won't count!

## Which items can be in another player's world?

Any shuffled item can be in other players' worlds. The twelve golden treasures can optionally be
shuffled into only your own world.

## What does another world's item look like in Wario Land 4?

Other games' items will look like Archipelago logos. Progression items will have an orange arrow,
and useful items will have a blue cross. When you collect an item, either its name or its
recipient's name will be displayed in the bottom right corner of the screen, depending on your
"Send Locations to Server" option.

## When the player receives an item, what happens?

If you receive a jewel piece or CD in a level, the game will show you what you got using a similar
display to when you take one from a chest. Unlike when the item is in a box, the item will be
available to be used immediately, rather than only after exiting the level. On the pyramid screen,
there will be a display using a pop-up window to tell the player what they received. If the item is
junk, Wario will receive it the next time he enters a level, or immediately if he's already in one.

## What does advanced logic mean?

Some items can be obtained by more difficult strategies that aren't obvious when you're playing the
vanilla game. Likewise, some levels expect certain abilities during their escapes, but those
abilities can be skipped with some setup steps on the way to the frog switch. Advanced logic can
expect you to use those strategies.

A full list of these strategies is as follows:

- In 40 Below Fridge, you can ground pound the switches in the maze puzzle room by getting a running
start and stomp jumping on the glass ball right after the glass bird spits it out.
- In The Toxic Landfill, you can lure the Ringosuki toward the water and grab the apple in midair to
get the Transformation Puzzle Lower Diamond without using Heavy Grab to throw it across the pool.
- In Pinball Zone, you can get through the fruit room with only grab by throwing one of the lower
pinballs at the ones on the ledges.
- Also in Pinball Zone, you can use Heavy Grab in place of Ground Pound in the jungle room by
carrying a Ringosuki to the top of the room and using Fat Wario.
- In Doodle Woods, you can reach the Gray Square Box on Hard and S-Hard by throwing a Toy Car at the
gray blocks. The Normal version of that room doesn't have any enemies you can throw.
- In Domino Row, you can open the way down the red tower by either breaking the blocks with Head
Smash or by throwing a Toy Car from the top of the room. You need to do one of these things to
escape without Ground Pound.
- In Arabian Night, you can reach the bottom of the room full of mummy enemies by throwing them at
the wooden boxes if you have Grab.
- In Hotel Horror, you can access the frog switch on Hard without carrying the Ringosuki by throwing
the Marumen upward and bouncing on it in midair to start a Super Ground Pound.
- To fight Catbat, you're normally expected to use Stomp Jump as the behavior when jumping off of
the waves is strange without it. To ground pound his head without Stomp Jump, you need to start
walking before you jump; jumps from a standstill won't work. When the waves start oscillating, jump
at the apex or else you will be bounced off.
- In Golden Passage, you can skip the current puzzle room by repeatedly jumping out of the river
with good timing.

Videos of some of these strategies can be found at this YouTube playlist: [Wario Land 4 Archipelago
Tricks](https://www.youtube.com/playlist?list=PL9fyDZ3k7Qw0WclTCDDImKQDjNi2Sy0Gp)
